<?xml version="1.0"?>
<!--xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl" default-space="preserve" indent-result="yes"-->
<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:msxsl="urn:schemas-microsoft-com:xslt"
 xmlns:user="urn:schemas-imedica.com:prm">

<xsl:template match="ROOT">
	<xsl:apply-templates select="*"/>
</xsl:template>

<xsl:template match="Person">
<xsl:element name="DIV">
  <xsl:attribute name="ID">printDiv</xsl:attribute>
  <xsl:attribute name="name">Demographics</xsl:attribute>
	<table border="0" cellpadding="1" cellspacing="0" align="center" style="table-layout: fixed;" width="98%" class="small">
	<col width="5%"/><col width="45%"/><col width="50%"/>
		<tr>
			<td id="personname" colspan="2">
				<B>Name:</B>&#xa0;
				<a href="#" hint="Click here to edit this patient">
					<xsl:attribute name="onClick">if(iMedica.Patient.Edit('<xsl:value-of select="@PersonUid"/>')) init1();</xsl:attribute>
					<xsl:value-of select="@FullNameFormal"/>
				</a>
			</td>
			<xsl:if test="Patient">
				<td rowspan="6" valign="top">
					<xsl:choose>
						<xsl:when test="string(@PhotoAttachmentUid) = ''">
							<img>
								<xsl:attribute name="src">..\Images\noPhoto.gif</xsl:attribute>
								<xsl:attribute name="title">No Patient Photo Exist</xsl:attribute>
							</img>
						</xsl:when>
						<xsl:otherwise>
							<a href="#" hint="Click here to view the patient photo">
								<xsl:attribute name="onClick">
									if(iMedica.Patient.OpenAttachment('<xsl:value-of select="@PhotoAttachmentUid"/>')) init1();
								</xsl:attribute>
								<img>
									<xsl:attribute name="src">
										..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.AttachmentThumbnail.aspx?AttachmentUid=<xsl:value-of select="@PhotoAttachmentUid"/>
									</xsl:attribute>
									<xsl:attribute name="title">Patient Photo</xsl:attribute>
								</img>
							</a>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:if>
		</tr>
		<tr>
			<td id="externalid" colspan="2">
				<B>External ID:</B>&#xa0;<xsl:value-of select="Patient/@ExternalID"/>
			</td>
		</tr>
		<tr>
			<td id="aka" colspan="2">
				<B>Also Known As:</B>&#xa0;<xsl:value-of select="@AKAFullNameFormal"/>
			</td>
		</tr>
		<!--tr>
			<td colspan="2" class="small"><xsl:if test="ISPATIENT[.=1]"><B>Practice Provider:</B>&#xa0;<xsl:value-of select="PRACTICEPROVIDERNAME"/></xsl:if></td>
			<td class="small"><xsl:if test="ISPATIENT[.=1]"><B>Patient Status:</B>&#xa0;<xsl:value-of select="displayPATIENTSTATUS"/></xsl:if></td>
		</tr-->
		<tr>
			<td id="ssn" colspan="2"><B>Social Security Number:</B>&#xa0;<xsl:value-of select="@SocialSecurityNumber"/></td>
		</tr>
		<tr>
			<td id="mrn" colspan="2"><xsl:if test="Patient"><B>Medical Record Number:</B>&#xa0;<xsl:value-of select="Patient/@MedicalRecordNumber"/></xsl:if></td>
		</tr>
		<tr>
			<td id="pcp" colspan="2"><xsl:if test="Patient"><B>Practice Provider:</B>&#xa0;<xsl:value-of select="Patient/@PrimaryProviderName"/></xsl:if></td>
			<!--td id="pcp" colspan="2"><xsl:if test="Patient"><B>Primary Care Provider:</B>&#xa0;<span class="FindControl" BusinessObject="ViewProviderFactory" fcReadOnly="true"><xsl:attribute name="fcForeignKeyUid"><xsl:value-of select="Patient/@ProviderUid"/></xsl:attribute>&#xa0;</span></xsl:if></td -->
		</tr>
    <tr>
      <td id="prp" colspan="2">
        <xsl:if test="Patient">
          <!--B>Referring Provider:</B>&#xa0;				
          <a href="#" hint="Click here to edit this patient's referring providers">
            <xsl:attribute name="onClick">
              if(iMedica.Patient.Edit('<xsl:value-of select="@PersonUid"/>')) init1();
            </xsl:attribute>
            <xsl:value-of select="Patient/@ReferringProviderName"/>
          </a -->
          <B>Referring Provider:</B>&#xa0;
          <xsl:choose>
            <xsl:when test="string(Patient/@ReferringProviderName) = ''">
              <a href="#" hint="Click here to edit the referring provider">
                <xsl:attribute name="onClick">
                  iMedica.Patient.EditPatientProviderRelationship(''); init1();
                </xsl:attribute>
                None
              </a>
            </xsl:when>
            <xsl:otherwise>
              <a href="#" hint="Click here to edit the referring provider">
                <xsl:attribute name="onClick">
                  iMedica.Patient.EditPatientProviderRelationship('<xsl:value-of select="Patient/@PatientProviderRelationshipUid"/>'); init1();
                </xsl:attribute>
                <xsl:value-of select="Patient/@ReferringProviderName"/>
              </a>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </td>
    </tr>
		<tr>
			<td id="dob" colspan="2"><B>Date of Birth:</B>&#xa0;<xsl:value-of select="@Birthdate"/></td>
		</tr>
		<tr>
			<td id="mrn" colspan="2">
				<xsl:if test="Patient">
					<B>Age:</B>&#xa0;<xsl:value-of select="Patient/@Age"/>
				</xsl:if>
			</td>
		</tr>
		<tr>
      <td id="gender" colspan="2"><B>Current Sex:</B>&#xa0;<xsl:value-of select="@Gender"/></td>			
    <!-- td id="gender" colspan="2"><B>Gender:</B>&#xa0;<span class="FindControl" BusinessObject="ListGenderFactory" fcReadOnly="true"><xsl:attribute name="fcForeignKeyUid"><xsl:value-of select="@GenderUid"/></xsl:attribute>&#xa0;</span></td -->
		</tr>
    <tr>
      <td id="genderidentity" colspan="2">
        <B>Gender Identity:</B>&#xa0;<xsl:value-of select="@GenderIdentity"/>
      </td>
    </tr>
    <tr>
      <td id="sexualorientation" colspan="2">
        <B>Sexual Orientation:</B>&#xa0;<xsl:value-of select="@SexualOrientation"/>
      </td>
    </tr>
    <tr>
      <td id="pcm" colspan="2"><B>Preferred Contact Method:</B>&#xa0;<xsl:value-of select="@PreferredContactMethod"/></td>
    </tr>    
<!-- *** MIX IN THE ADDRESSES *** -->
<!--xsl:apply-templates select="Address"/-->
		<tr><td colspan="2" valign="top">
			<xsl:call-template name="Address"><xsl:with-param name="node" select="Address1"/><xsl:with-param name="displayorder" select="1"/></xsl:call-template>
		</td>
		<td valign="top">
			<xsl:call-template name="Address"><xsl:with-param name="node" select="Address2"/><xsl:with-param name="displayorder" select="2"/></xsl:call-template>
		</td></tr>
<!-- *** MIX IN THE PHONENUMBERS *** -->
		<tr>
			<td colspan="3"><B>Phone Numbers:</B></td>
		</tr>
		<tr>
			<td>&#xa0;</td>
			<xsl:call-template name="Phone"><xsl:with-param name="node" select="Phone1"/><xsl:with-param name="displayorder" select="1"/></xsl:call-template>
      <xsl:call-template name="Phone"><xsl:with-param name="node" select="Phone2"/><xsl:with-param name="displayorder" select="2"/></xsl:call-template>
		</tr>
		<tr>
			<td>&#xa0;</td>
      <xsl:call-template name="Phone"><xsl:with-param name="node" select="Phone3"/><xsl:with-param name="displayorder" select="3"/></xsl:call-template>
      <xsl:call-template name="Phone"><xsl:with-param name="node" select="Phone4"/><xsl:with-param name="displayorder" select="4"/></xsl:call-template>
		</tr>
		<!--tr>
			<td id="comment" colspan="3" class="small"><B>Comment:</B>&#xa0;<xsl:value-of select="COMMENT"/></td>
		</tr-->

    <tr>
      <td colspan="3"><b>Email Addresses:</b>
        <xsl:choose>
          <xsl:when test="string(@NoEmailAddressProvided) = 'True'">
            Patient declined or does not have an email address
          </xsl:when>
         </xsl:choose>
      </td>
    </tr>
    <tr>
      <td>&#xa0;</td>
      <xsl:call-template name="Email"><xsl:with-param name="displayorder" select="1"/><xsl:with-param name="strEmailAddress" select="@Email1"/></xsl:call-template>
      <xsl:call-template name="Email"><xsl:with-param name="displayorder" select="2"/><xsl:with-param name="strEmailAddress" select="@Email2"/></xsl:call-template>      
    </tr>
    <tr>
      <td colspan="3" style="width:100%; height:2px"></td>
    </tr>
    <!--
		<tr>
			<td id="employer" colspan="2"></td>
			<td><B>E-mail Address:&#xa0;</B>
				<xsl:call-template name="Email"><xsl:with-param name="strEmailAddress" select="@Email1"/><xsl:with-param name="displayorder" select="1"/></xsl:call-template>
				<xsl:if test="string-length(@Email2)"><br/></xsl:if>
				<xsl:call-template name="Email"><xsl:with-param name="strEmailAddress" select="@Email2"/><xsl:with-param name="displayorder" select="2"/></xsl:call-template>
			</td>
		</tr>
    -->
    
		<!--tr>
			<td colspan="2" class="small"><xsl:if test="ISPATIENT[.=1]"><B>Release Records:</B>&#xa0;<xsl:choose><xsl:when test="PATIENTRELEASESTATUS[.='1']">Yes</xsl:when><xsl:otherwise>No</xsl:otherwise></xsl:choose></xsl:if></td>
			<td class="small"><xsl:if test="ISPATIENT[.=1]"><B>Date Release Signed:</B>&#xa0;<xsl:value-of select="PATIENTRELEASEDATE"/></xsl:if></td>
		</tr-->
		<tr>
			<td id="maritalstatus" colspan="2"><B>Marital Status:</B>&#xa0;<xsl:value-of select="@MaritalStatus"/></td>
			<!-- td id="maritalstatus" colspan="2"><B>Marital Status:</B>&#xa0;<span class="FindControl" BusinessObject="ListMaritalStatusFactory" fcReadOnly="true"><xsl:attribute name="fcForeignKeyUid"><xsl:value-of select="@MaritalStatusUid"/></xsl:attribute>&#xa0;</span></td -->
      <td id="race">
        <B>Race:</B>
        <xsl:variable name="raceList">
          <xsl:for-each select="RelPersonRace">
            , <xsl:value-of select="ListRace/@Name"/>
          </xsl:for-each>
        </xsl:variable>
        <xsl:value-of select="substring-after($raceList, ',')"/>
      </td>
		</tr>
		<tr>
			<td id="language" colspan="2"><B>Preferred Language:</B>&#xa0;<xsl:value-of select="@Language"/></td>
			<!--<td id="language" colspan="2"><B>Language:</B>&#xa0;<span class="FindControl" BusinessObject="ListLanguageFactory" fcReadOnly="true"><xsl:attribute name="fcForeignKeyUid"><xsl:value-of select="@LanguageUid"/></xsl:attribute>&#xa0;</span></td>-->
			<!--<td id="ethnicity"><B>Ethnicity:</B>&#xa0;<xsl:value-of select="@Ethnicity"/></td>-->
			<!--<td id="ethnicity"><B>Ethnicity:</B>&#xa0;<span class="FindControl" BusinessObject="ListEthnicityFactory" fcReadOnly="true"><xsl:attribute name="fcForeignKeyUid"><xsl:value-of select="@EthnicityUid"/></xsl:attribute>&#xa0;</span></td>-->
      <td id="ethnicity">
        <B>Ethnicity:</B>
        <xsl:variable name="ethnicityList">
          <xsl:for-each select="RelPersonEthnicity">
            , <xsl:value-of select="ListEthnicity/@Name"/>
          </xsl:for-each>
        </xsl:variable>
        <xsl:value-of select="substring-after($ethnicityList, ',')"/>
      </td>
		</tr>
		<tr>
      <td id="translatorrequired" colspan="2"><B>Translator Required:</B>&#xa0;
        <xsl:choose>
        <xsl:when test="string(@TranslatorRequired) = 'True'">
          Yes
          </xsl:when>
          <xsl:otherwise>No</xsl:otherwise>
          </xsl:choose>
			</td>
      <!--<td colspan="2"/>-->
			<td id="dominantHand" colspan="2"><B>Dominant Hand:</B>&#xa0;<xsl:value-of select="@DominantHand"/></td>
			<!--<td id="dominantHand" colspan="2"><B>Dominant Hand:</B>&#xa0;<span class="FindControl" BusinessObject="ListDominantHandFactory" fcReadOnly="true"><xsl:attribute name="fcForeignKeyUid"><xsl:value-of select="@DominantHandUid"/></xsl:attribute>&#xa0;</span></td>-->
		</tr>
    <tr>
      <td id="translatorrequired" colspan="2">
        <B>Interpreter Required:</B>&#xa0;
        <xsl:choose>
          <xsl:when test="string(@InterpreterRequired) = 'True'">
            Yes
          </xsl:when>
          <xsl:otherwise>No</xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
		<tr>
			<td id="driverlicensenumber" colspan="2">
				<xsl:if test="Patient">
					<xsl:choose>
						<xsl:when test="string(@DriverLicenseAttachmentUid) = ''">
							<B>Driver's License Number:</B>
						</xsl:when>
						<xsl:otherwise>
							<a href="#" hint="Click here to view the driver license">
								<xsl:attribute name="onClick">
									if(iMedica.Patient.OpenAttachment('<xsl:value-of select="@DriverLicenseAttachmentUid"/>')) init1();
								</xsl:attribute>
								<B>Driver's License Number:</B>
							</a>
						</xsl:otherwise>
					</xsl:choose>
				&#xa0;<xsl:value-of select="@DriverLicenseState"/>&#xa0;<xsl:value-of select="@DriverLicenseNumber"/>
				</xsl:if>
			</td>
		</tr>
    <tr>
      <td id="releasedate" colspan="2">
        <xsl:if test="Patient">
          <B>Release Signed Date:</B>&#xa0;<xsl:value-of select="user:getStringDate(string(Patient/@ReleaseDate))"/>
        </xsl:if>
      </td>
    </tr>
		<tr>
			<td id="scannedchartdate" colspan="2">
				<xsl:if test="Patient">
					<B>Original Chart Scanned:</B>&#xa0;<xsl:value-of select="user:getStringDate(string(Patient/@ScannedChartDate))"/>
				</xsl:if>
			</td>
		</tr>
		<tr>
      <td colspan="4" valign="top">
        <B>Patient Status:</B>
        <xsl:if test="Patient">
          <xsl:variable name="statusList">
            <!--xsl:if test="@Deathdate != ''">, Deceased</xsl:if-->
            <xsl:if test="Patient/@Inactive = 'True'">, Inactive</xsl:if>
            <xsl:for-each select="Patient/RelPatientStatus">, <xsl:value-of select="ListPatientStatus/@Name"/>
            </xsl:for-each>
          </xsl:variable>
          <xsl:value-of select="substring-after($statusList, ',')"/>
        </xsl:if>
      </td>
		</tr>
    <tr>
      <td colspan="2">
        &#xa0;
      </td>
    </tr>
    <tr>
      <td id="notes" colspan="2">
        <B>Notes:</B>&#xa0;<xsl:value-of select="@Notes"/>
      </td>
    </tr>
		<tr>
			<td colspan="3" align="center">
				<xsl:element name="DIV">
					<xsl:attribute name="id">printLink0</xsl:attribute>
					<xsl:attribute name="style">display:;</xsl:attribute>
					<!--input id="btnPrintDemographics" type="button" class="blueBtn" value="Edit Demographics" >
					<xsl:attribute name="onClick">if(iMedica.Patient.Edit('<xsl:value-of select="@PersonUid"/>')) init1();</xsl:attribute>
				</input>
				<input id="btnPrintIdentification" type="button" class="blueBtn" disabled="true" value="Edit Insurance" >
					<xsl:attribute name="onClick">if(iMedica.Patient.EditAccounts('<xsl:value-of select="@PersonGuid"/>')) init1();</xsl:attribute>
				</input>
				<input id="btnShowPIN" type="button" class="blueBtn" onClick="fnShowPin();" value="Show PIN" style="display:none" /-->
			</xsl:element>
			</td>
		</tr>
	</table>
</xsl:element>
</xsl:template>

<xsl:template match="Patient">


<!--
		<column name="PersonUid" javaName="PersonUid" required="true" type="UNIQUEIDENTIFIER" primaryKey="true" />
		<column name="Inactive" javaName="Inactive" required="true" type="BIT"/>
		<column name="MedicalRecordNumber" javaName="MedicalRecordNumber" required="false" type="VARCHAR" size="25"/>
		<column name="ClassUid" javaName="ClassUid" required="false" type="UNIQUEIDENTIFIER"/>
		<column name="ProviderUid" javaName="ProviderUid" required="false" type="UNIQUEIDENTIFIER"/>
		<column name="LocationUid" javaName="LocationUid" required="false" type="UNIQUEIDENTIFIER"/>
		<column name="DepartmentUid" javaName="DepartmentUid" required="false" type="UNIQUEIDENTIFIER"/>
		<column name="ReleaseInformation" javaName="ReleaseInformation" required="false" type="BIT"/>
		<column name="ReleaseDate" javaName="ReleaseDate" required="false" type="DATE"/>
		<column name="SignatureOnFile" javaName="SignatureOnFile" required="false" type="BIT"/>
		<column name="SignatureSourceUid" javaName="SignatureSourceUid" required="false" type="UNIQUEIDENTIFIER"/>
		<column name="AssignmentOfBenefitsID" javaName="AssignmentOfBenefitsID" required="false" type="INTEGER"/>
		<column name="PrivacyPolicyAcceptanceID" javaName="PrivacyPolicyAcceptanceID" required="false" type="INTEGER"/>
		<column name="StudentStatusUid" javaName="StudentStatusUid" required="false" type="UNIQUEIDENTIFIER"/>
		<column name="SchoolName" javaName="SchoolName" required="false" type="VARCHAR" size="50"/>
		<column name="RaceUid" javaName="RaceUid" required="false" type="UNIQUEIDENTIFIER"/>
		<column name="EthnicityUid" javaName="EthnicityUid" required="false" type="UNIQUEIDENTIFIER"/>
		<column name="ResidenceTypeUid" javaName="ResidenceTypeUid" required="false" type="UNIQUEIDENTIFIER"/>
		<column name="LastModifiedDate" javaName="LastModifiedDate" required="true" type="DATE"/>
		<column name="LastModifiedByUid" javaName="LastModifiedByUid" required="true" type="UNIQUEIDENTIFIER"/>
-->
</xsl:template>

  <xsl:template name="Email">
    <xsl:param name="strEmailAddress" />
    <xsl:param name="displayorder" />
    <td>
        <b>
          <xsl:value-of select="user:getEmailLabel(string($displayorder))"/>
        </b>&#xa0;
        <span>
          <xsl:if test="string-length($strEmailAddress)">
            <xsl:attribute name="ID">email<xsl:value-of select="$displayorder"/>_email</xsl:attribute>
            <a><xsl:attribute name="href">mailto:<xsl:value-of select="$strEmailAddress"/></xsl:attribute><xsl:value-of select="$strEmailAddress"/></a>
          </xsl:if>&#xa0;
        </span>
    </td>
  </xsl:template>  
  
  <xsl:template name="Phone">
  <xsl:param name="node" />
  <xsl:param name="displayorder" />
    <td>
        <b><xsl:value-of select="user:getPhoneNumberLabel(string($displayorder))"/></b>&#xa0; 
        <span>
          <xsl:if test="string-length($node)">
            <xsl:value-of select="$node/Phone/PhoneNumber"/>&#xa0;<b><xsl:value-of select="$node/Phone/PhoneType"/></b>&#xa0;
            <xsl:if test="$node/Phone/SmsEnabled = 'True'">
              <img width="16" height="20">
                <xsl:attribute name="src">..\Images\phone-txt-sm.png</xsl:attribute>
              </img>
            </xsl:if>
            <xsl:if test="$node/Phone/SmsEnabled = 'False'">
              <img width="12" height="20">
                <xsl:attribute name="src">..\Images\phone-notxt-sm.png</xsl:attribute>
              </img>
            </xsl:if>
          </xsl:if>&#xa0;
        </span>
    </td>
  </xsl:template>

  <!--xsl:template match="Address"-->
<xsl:template name="Address">
<xsl:param name="node" />
<xsl:param name="displayorder" />
	<!--xsl:if test="string-length($node/@AddressUid)"-->
	<table cellpadding="1" cellspacing="0" align="center" style="table-layout: fixed;" class="small">
		<col width="5%"/><col width="95%"/>
		<tr>
			<td colspan="2"><B><xsl:value-of select="user:getAddressLabel(string($displayorder))"/>:</B>
        <xsl:if test="string-length($node/Address/Address1)">
          <xsl:choose>
          <xsl:when test="user:isBadAddress(string($displayorder), string(@BadAddress1)) = 'True'">
            <B> ***Mail is undeliverable***</B>
          </xsl:when>          
        </xsl:choose>
        </xsl:if>
      </td>
		</tr>
		<xsl:if test="string-length($node/Address/Address1)">
		<tr>
      <td>&#xa0;</td>
			<td>
        <xsl:attribute name="ID">address<xsl:value-of select="$displayorder"/>_address1</xsl:attribute>
				<xsl:value-of select="$node/Address/Address1"/>
			</td>
		</tr>
		</xsl:if>
		<xsl:if test="string-length($node/Address/Address2)">
		<tr>
			<td>&#xa0;</td>
			<td>
				<xsl:attribute name="ID">address<xsl:value-of select="$displayorder"/>_address2</xsl:attribute>
				<xsl:value-of select="$node/Address/Address2"/>
			</td>
		</tr>
		</xsl:if>
		<xsl:if test="string-length($node/Address/City) or string-length($node/Address/State) or string-length($node/Address/Zip)">
		<tr>
			<td>&#xa0;</td>
			<td>
				<xsl:attribute name="ID">address<xsl:value-of select="$displayorder"/>_citystatezip</xsl:attribute>
				<xsl:value-of select="$node/Address/City"/>&#32;<xsl:value-of select="$node/Address/State"/>&#32;<xsl:value-of select="$node/Address/Zip"/>
			</td>
		</tr>
		</xsl:if>
		<xsl:if test="string-length($node/Address/Country)">
		<tr>
			<td>&#xa0;</td>
			<td>
				<xsl:attribute name="ID">address<xsl:value-of select="$displayorder"/>_country</xsl:attribute>
				<xsl:value-of select="$node/Address/Country"/>
			</td>
		</tr>
		</xsl:if>
		<tr>
			<td></td>
			<td></td>
		</tr>
	</table>
	<!--/xsl:if-->

</xsl:template>

<msxsl:script language="Jscript" implements-prefix="user">
	<![CDATA[

    function getEmailLabel(sDisplayOrder)
    {
      if (sDisplayOrder == "1")
        return "1.";
      else if (sDisplayOrder == "2")
        return "2.";
      else 
        return sDisplayOrder;
    }

    function getPhoneNumberLabel(sDisplayOrder)
    {
      if (sDisplayOrder == "1")
        return "1.";
      else if (sDisplayOrder == "2")
        return "2.";
      else if (sDisplayOrder == "3")
        return "3.";
      else if (sDisplayOrder == "4")
        return "4.";
      else 
        return sDisplayOrder;
    }

		function getAddressLabel(sDisplayOrder)
		{
			if (sDisplayOrder == "1")
				return "Primary Address";
			else if (sDisplayOrder == "2")
				return "Secondary Address";
			else
				return "Address " + sDisplayOrder;
		}
    
    function isBadAddress(sDisplayOrder, sBadAddress)
		{
			if (sDisplayOrder == "1" && sBadAddress == 'True')
				return 'True';
			else
				return 'False';
		}

		function convertXMLDateTimeToJSDateObj(strDate)
		{
			// parse the XML datetime string: yyyy-mm-ddThh:mm:ss into mm-dd-yyyy hh:mm: (?)
			return new Date(strDate.substring(5,10) + '-' + strDate.substring(0,4) + ' ' + strDate.substring(11,16));
		}

		function convertDateToJSDateObj(strDate)
		{
			// parse the XML datetime string: mm/dd/yyyy hh:mm:ss into mm-dd-yyyy
			return new Date(strDate.replace(/\//g,'-'));
		}

		function convertDateToStringDate(dDate)
		{
			var theMonth = (dDate.getMonth()+1);
			var theDate = dDate.getDate();
			if (theMonth < 10) {
				theMonth = "0" + (theMonth);
			}
			if (theDate < 10) {
				theDate = "0" + theDate;
			}
			var strDate = theMonth + "/" + theDate + "/" + dDate.getFullYear().toString();
			return strDate;
		}

		function getStringDate(sXMLDateTime)
		{
			if (sXMLDateTime != "")
				return convertDateToStringDate(convertXMLDateTimeToJSDateObj(sXMLDateTime));
			return "";
		}		
	]]>
</msxsl:script>

</xsl:stylesheet>