function clearChartContext(strPageTitle)
{
	theEncounterID = 0;
	theChartID = 0;
	theChartPersonID = 0;
	if (typeof(xmlChart) == "object")
		xmlChart.loadXML("<root></root>");
	document.title = strPageTitle;
	parent.fnAddChartContextToDesktop(0, 0);
	showMainMenu();
	parent.update();
	if (typeof(aNoChart) == "object")
		aNoChart.style.visibility = 'hidden';
}

function makeAge(strDOB)
{
	var theDayofYearDOB, theDayofYearDate, intAGE, theDeltaAge;
	var theDate, theYearDOB, theYearDate, theMonthDOB, theMonthDate, theDayDOB, theDayDate;
	var i,j,diff;
	var today = new Date();

	if (strDOB != ""){
		i = strDOB.indexOf("/")+1; //point past month
		theMonthDOB = strDOB.substring(0,i-1); //the month part of the DOB
		j = strDOB.indexOf("/",i+1);	//point past day
		theDayDOB = strDOB.substring(i,j); //the day part of the DOB
		theYearDOB = strDOB.substring(j+1); //the year part of the DOB
		theYearDate = today.getFullYear();	//the year part of today
		theMonthDate = today.getMonth(); //the month part of today
		++theMonthDate;
		theDayDate = today.getDate();  //the day part of today
		//
		//first, let's look and see if we can use number of years (>= 3 years old)
		//
		intAGE = theYearDate - theYearDOB;
		if (theMonthDate < theMonthDOB){
			theDeltaAge = -1; //today is before birthdate
		}else{
			if (theMonthDate > theMonthDOB){
				theDeltaAge = 0; //today is after birthdate
			}else{  //this month is birthdate
				if (theDayDate >= theDayDOB){
					theDeltaAge = 0; //today is after birthdate
				}else{
					theDeltaAge = -1; //today is before birthdate
				}		
			}		
		}
		intAGE = intAGE + theDeltaAge;
		if (intAGE >= 3){
			return "" + intAGE + " YO";
		}else{
			//
			//it's less than 3 years.  If it's 3 months or more, use the months
			//
			intAGE = intAGE * 12;			  //number of months based on year
			if ((theMonthDOB < theMonthDate) || ((theMonthDOB == theMonthDate) && (theDayDOB <= theDayDate))){
				intAGE = intAGE + (theMonthDate - theMonthDOB);
			}else{
				intAGE = intAGE + (theMonthDate + 12 - theMonthDOB);
			}
			if (theDayDate < theDayDOB) intAGE = intAGE - 1;
			if (intAGE >= 3){
				return "" + intAGE + " MO";
			}else{
				//
				// it's less than 3 months.  Use days if less than 29 days.  Otherwise weeks.
				//

				// convoluted way to determine dateDiff
				var t, n, nDiff;
				var MinMilli = 1000 * 60;
				var HrMilli = MinMilli * 60;
				var DyMilli = HrMilli * 24;
				t = Date.parse(strDOB);
				diff = Math.round(Math.abs(t / DyMilli));
				n = Date.parse(today);
				nDiff = Math.round(Math.abs(n / DyMilli));
				diff = nDiff - diff - 1;

				intAGE = parseInt(diff,10);  // DateDiff on days seems to work ok
				if (intAGE < 29){
					if (intAGE < 0){
						intAGE = 0;  // DOB should be prior to today, but just in case...
					}						
					return "" + intAGE + " DO";
				}else{
					s = "" + intAGE/7;
					return "" + parseInt(s,10) + " WO";
				}
			} 
		}
	}else{
		return "? YO ";
	}
}