<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:msxsl="urn:schemas-microsoft-com:xslt"
 xmlns:user="urn:schemas-imedica.com:prm">
	<xsl:template match="ROOT/Person">
		<xsl:element name="DIV">
		  <xsl:attribute name="ID">accountsDetailsDisplayDiv</xsl:attribute>
		  <xsl:element name="DIV">
			<xsl:attribute name="ID">printDiv</xsl:attribute>
			<xsl:attribute name="name">Accounts</xsl:attribute>
      			<xsl:variable name="accountNodes" select="Account" />
      			<xsl:variable name="accountNodeCount" select="count($accountNodes)" />
			<xsl:for-each select="Account">
				<xsl:sort select="@IsMain" data-type="text" order="descending"></xsl:sort>
				<xsl:element name="DIV">
					<xsl:attribute name="ID">AID<xsl:value-of select="AccountUid"/></xsl:attribute>
					<xsl:attribute name="NAME">AID<xsl:value-of select="AccountUid"/></xsl:attribute>
					<xsl:attribute name="STYLE">width:98%;</xsl:attribute>
					<xsl:if test="@IsMain[.!='True']">
						<TABLE border="0" cellpadding="0" cellspacing="0" width="98%" align="center">
							<TR width="100%" height="10"><TD></TD></TR>
						</TABLE>
						<TABLE border="1" cellpadding="0" cellspacing="0" width="98%" align="center">
							<TR width="100%" height="1"><TD></TD></TR>
						</TABLE>
					</xsl:if>
					<TABLE border="0" cellpadding="0" cellspacing="0" width="98%" align="center">
						<TR valign="center" height="30">
							<TD colspan="2" class="std">
								<B>Account:</B>&#xa0;
								<a href="#" title="Click here to edit this account">
									<xsl:attribute name="onClick">if(iMedica.Patient.EditAccount('<xsl:value-of select="@AccountUid"/>')) init1();</xsl:attribute>
									<xsl:value-of select="@Name"/>
								</a>
							</TD>
              <xsl:if test="@IsMain[.='True']">
                <TD width="150px" class="small">
                  <a href="#">
                    <xsl:attribute name="onClick">
                      if(iMedica.Patient.AddAccount('<xsl:value-of select="@PersonUid"/>')) init1();
                    </xsl:attribute>
                    <xsl:attribute name="title">Click here to add a new account, this is only needed if the account has a different responsible party.  To just change insurance, edit the existing account and create a new account period.</xsl:attribute>
                    Add New Account
                  </a></TD>
              </xsl:if>
						</TR>
						<TR>
							<TD width="44%" class="small"><B>Account External ID:</B>&#xa0;<xsl:value-of select="string(@ExternalID)"/></TD>
              <xsl:for-each select="AccountPeriod[@IsCurrent='True']">
                <!--<TD width="36%" class="small"><B>Account Type:</B>&#xa0;<span class="FindControl" BusinessObject="ListAccountTypeFactory" fcReadOnly="true"><xsl:attribute name="fcForeignKeyUid"><xsl:value-of select="@AccountTypeUid"/></xsl:attribute>&#xa0;</span></TD>-->
                <TD width="36%" class="small">
                  <B>Account Type:</B>&#xa0;<xsl:value-of select="@AccountType"/>
                </TD>
                <TD width="36%" class="small">
                  <B>Coverage Type:</B>&#xa0;<xsl:value-of select="../@CoverageType"/>
                </TD>
                <!--<B>Coverage Type:</B>&#xa0;<span class="FindControl" BusinessObject="ListCoverageTypeFactory" fcReadOnly="true"><xsl:attribute name="fcForeignKeyUid"><xsl:value-of select="@CoverageTypeUid"/></xsl:attribute>&#xa0;</span>-->
							<TD>&#xa0;</TD>
              </xsl:for-each>
            </TR>
						<TR valign="bottom">
							<TD class="small"><B>Total Account Balance:</B>&#xa0;<xsl:value-of select="user:toCurrency(string(AR_ViewAccountAggregate/@LiabilityBalance))"/></TD>
							<TD colspan="2" class="small"><B>Patient Balance:</B>&#xa0;<xsl:value-of select="user:toCurrency(string(AR_ViewAccountAggregate/@UnassignedLiabilityBalance))"/></TD>
						</TR>
						<TR valign="bottom">
							<TD colspan="3" class="small">&#xa0;</TD>
						</TR>
            <TR valign="bottom">
              <TD class="small">
                    <B>Responsible Party External ID:</B>&#xa0;<xsl:value-of select="AccountResponsibleParty/@ExternalID"/>
              </TD>
              <TD class="small">
                <B>Responsible Party Balance:</B>&#xa0;
                <xsl:choose>
                  <xsl:when test="AccountResponsibleParty/Person/ViewResponsibleParty">
                    <xsl:value-of select="user:toCurrency(string(AccountResponsibleParty/Person/ViewResponsibleParty/@PersonBalanceAll))"/>
                  </xsl:when>
                  <xsl:when test="AccountResponsibleParty/Corporation/ViewResponsibleParty">
                    <xsl:value-of select="user:toCurrency(string(AccountResponsibleParty/Corporation/ViewResponsibleParty/@PersonBalanceAll))"/>
                  </xsl:when>
                  <xsl:when test="../ViewResponsibleParty">
                    <xsl:value-of select="user:toCurrency(string(../ViewResponsibleParty/@PersonBalanceAll))"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="user:toCurrency(string(//ViewResponsibleParty[@AccountResponsiblePartyUid = ./@AccountResponsiblePartyUid]/@PersonBalanceAll))"/>
                  </xsl:otherwise>
                </xsl:choose>
              </TD>
              <TD class="small">
								<B>Payer Credit Balance:</B>&#xa0;
								<a href="#" title="Click here to edit this Responsible Party Credit">
								<xsl:attribute name="onClick">if(iMedica.Patient.EditPayerCredit('<xsl:value-of select="@AccountUid"/>')) init1();</xsl:attribute>
								<xsl:choose>
									<xsl:when test="AccountResponsibleParty/Person/ViewResponsibleParty">
										<xsl:value-of select="user:toCurrency(string(AccountResponsibleParty/Person/ViewResponsibleParty/@PayerCreditBalance))"/>
									</xsl:when>
									<xsl:when test="AccountResponsibleParty/Corporation/ViewResponsibleParty">
										<xsl:value-of select="user:toCurrency(string(AccountResponsibleParty/Corporation/ViewResponsibleParty/@PayerCreditBalance))"/>
									</xsl:when>
									<xsl:when test="../ViewResponsibleParty">
										<xsl:value-of select="user:toCurrency(string(../ViewResponsibleParty/@PayerCreditBalance))"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="user:toCurrency(string(//ViewResponsibleParty[fSendstatement]/@PayerCreditBalance))"/>
									</xsl:otherwise>
								</xsl:choose>
								</a>
							</TD>
						</TR>
              <TR valign="bottom">
							  <TD class="small"><B>Responsible Party:</B>&#xa0;
								  <xsl:if test="AccountResponsibleParty/@PersonUid">
								  <a href="#" title="Click here to edit this account responsible party">
									  <xsl:attribute name="onClick">if(iMedica.Patient.EditAccountResponsibleParty('<xsl:value-of select="AccountResponsibleParty/@AccountResponsiblePartyUid"/>')) init1();</xsl:attribute>
									  <xsl:value-of select="AccountResponsibleParty/Person/@LastName"/>, <xsl:value-of select="AccountResponsibleParty/Person/@FirstName"/>
								  </a>
								  </xsl:if>
								  <xsl:if test="AccountResponsibleParty/@CorporationUid">
									  <xsl:value-of select="AccountResponsibleParty/Corporation/@Name"/>
								  </xsl:if>
							  </TD>
                <TD class="small"><B>Collection Status:</B>&#xa0;
                    <xsl:choose>
                      <xsl:when test="AccountResponsibleParty/@CollectionHistoryStatus">
                        <xsl:choose>
                          <xsl:when test="AccountResponsibleParty/@CollectionHistoryStatus='Alerted'">
                            <font color="darkorange">
                              <xsl:value-of select= "AccountResponsibleParty/@CollectionHistoryStatus"/>
                            </font>
                          </xsl:when> 
                          <xsl:otherwise>
                            <font color="red">
                              <xsl:value-of select= "AccountResponsibleParty/@CollectionHistoryStatus"/>
                            </font>
                          </xsl:otherwise> 
                        </xsl:choose>
                      </xsl:when> 
                    </xsl:choose>
                </TD>
							  <TD class="small"><B>Last Statement:</B>&#xa0;<xsl:value-of select="@LastStatementDate"/></TD>
						</TR>
						<TR valign="bottom">
              <TD class="small"><B>Sufficient Payment Due:</B>&#xa0;<xsl:value-of select="user:toCurrency(string(AccountResponsibleParty/@CalculatedPaymentAmount))"/></TD>
							<TD class="small"><B>Due Date:</B>&#xa0;<xsl:value-of select="AccountResponsibleParty/@CollectionStatusExpirationDate"/></TD>
						  <TD class="small">
						    <xsl:attribute name="ID">sendStatementSpan<xsl:value-of select="AccountUid"/></xsl:attribute>
						    <B>Statement:</B>&#xa0;<xsl:value-of select="AccountResponsibleParty/ViewAccountResponsiblePartySendStatement/@SendStatementComment"/>
						  </TD>
						</TR>
					</TABLE>
          <xsl:if test="ViewPrimaryInsurance/@FormularyOrgUid">
            <TABLE border="0" cellpadding="0" cellspacing="0" width="98%" align="center" style="display:">
              <TR valign="bottom">
                <TD class="small">
                  <B>Drug Formulary</B>:
                  <xsl:value-of select="ViewPrimaryInsurance/@FormularyOrgName"/>
                </TD>
              </TR>
            </TABLE>
          </xsl:if>
          <xsl:for-each select="AccountPeriod[@IsCurrent='True']">
						<TABLE border="0" cellpadding="0" cellspacing="0" width="98%" align="center">
							<TR valign="bottom" align="center" height="24">
								<TD class="std"><B>

                  Current Insurance (<xsl:value-of select="user:getStringPeriodStartDate(string(@EffectiveDate))"/>-<xsl:value-of select="user:getStringPeriodDate(string(@ExpirationDate))"/>):
							&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;
                  <xsl:variable name="PlanMemberID" select="user:UCString(string(ViewAccountPeriodEligibilityDate/@PlanMemberID))" />
                  <xsl:variable name="eligibilitySubscriberID" select="user:UCString(string(ViewAccountPeriodEligibilityDate/@eligibilitySubscriberID))" />
                  <xsl:variable name="abc" select="user:altString($PlanMemberID,$eligibilitySubscriberID, string(ViewAccountPeriodEligibilityDate/@OtherPayerTypeCode))" />
                  <xsl:choose>
                    <xsl:when test="ViewAccountPeriodEligibilityDate/@EligibilityStatus = 'Processing'">
                      <img class="handCursor" src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityProcessing.png" width="16" height="16" border="0" alt="Eligibility Processing" >
                        <xsl:attribute name="onclick">
                          iMedica.Common.OpenEligibility('<xsl:value-of select="@AccountUid"/>')
                        </xsl:attribute>
                      </img>
                    </xsl:when>
                    <xsl:when test="ViewAccountPeriodEligibilityDate/@EligibilityStatus = 'ActiveCoverage'">
                      <xsl:choose>
                        <xsl:when test="(($PlanMemberID != $eligibilitySubscriberID) and(string($eligibilitySubscriberID))) or (string(ViewAccountPeriodEligibilityDate/@OtherPayerTypeCode) and string-length(ViewAccountPeriodEligibilityDate/@OtherPayerTypeCode) > 0)">
                          <img class="handCursor" src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityActiveNote.png" width="16" height="16" border="0" alt="{$abc}" >
                            <xsl:attribute name="onclick">
                              iMedica.Common.OpenEligibility('<xsl:value-of select="@AccountUid"/>')
                            </xsl:attribute>
                          </img>
                        </xsl:when>
                        <xsl:otherwise>
                          <img class="handCursor" src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityActive.png" width="16" height="16" border="0" alt="Eligibility Active Coverage" >
                            <xsl:attribute name="onclick">
                              iMedica.Common.OpenEligibility('<xsl:value-of select="@AccountUid"/>')
                            </xsl:attribute>
                          </img>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:when>
                    <xsl:when test="ViewAccountPeriodEligibilityDate/@EligibilityStatus = 'InactiveCoverage'">
                      <img class="handCursor" src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityInactive.png" width="16" height="16" border="0" alt="Eligibility Inactive Coverage">
                        <xsl:attribute name="onclick">
                          iMedica.Common.OpenEligibility('<xsl:value-of select="@AccountUid"/>')
                        </xsl:attribute>
                      </img>
                    </xsl:when>
                    <xsl:when test="ViewAccountPeriodEligibilityDate/@EligibilityStatus = 'Error'">
                      <img class="handCursor" src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityError.png" width="16" height="16" border="0" alt="Eligibility Error">
                        <xsl:attribute name="onclick">
                          iMedica.Common.OpenEligibility('<xsl:value-of select="@AccountUid"/>')
                        </xsl:attribute>
                      </img>
                    </xsl:when>
                    <xsl:when test="ViewAccountPeriodEligibilityDate/@EligibilityStatus = 'Expired'">
                      <img class="handCursor" src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityExpired.png" width="16" height="16" border="0" alt="Eligibility Expired">
                        <xsl:attribute name="onclick">
                          iMedica.Common.OpenEligibility('<xsl:value-of select="@AccountUid"/>')
                        </xsl:attribute>
                      </img>
                    </xsl:when>
                    <xsl:when test="ViewAccountPeriodEligibilityDate/@EligibilityStatus = 'Unknown'">
                      <img class="handCursor" src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityUnknown.png" width="16" height="16" border="0" alt="Eligibility Unknown">
                        <xsl:attribute name="onclick">
                          iMedica.Common.OpenEligibility('<xsl:value-of select="@AccountUid"/>')
                        </xsl:attribute>
                      </img>
                    </xsl:when>
                  </xsl:choose>
                  <a href="#" title="Click here to edit eligibility">
										<xsl:attribute name="onClick">
											if(iMedica.Patient.EditEligibility('<xsl:value-of select="@AccountUid"/>')) init1();
										</xsl:attribute>
										Eligibility</a>&#xa0;Date <xsl:value-of select="user:getDateOnly(string(ViewAccountPeriodEligibilityDate/@EligibilityDate))" />
							</B></TD>
							</TR>
						</TABLE>
						<TABLE border="0" cellpadding="0" cellspacing="0" width="98%" align="center" id="acctInsTableHeader" style="table-layout: fixed;">
							<COL width="50"/>
							<COL width="110"/>
							<COL width="110"/>
							<COL width="60"/>
							<COL width="50"/>
							<COL width="50"/>
							<COL width="60"/>
              <COL width="55"/>
              <COL width="55"/>
              <COL width="55"/>
							<TR class="insideGreyHeader">
								<TD align="left" nowrap="true"><SPAN class="tiny">Ins</SPAN></TD>
								<TD align="left" nowrap="true"><SPAN class="tiny">Ins Subscriber</SPAN></TD>
								<TD align="left" nowrap="true"><SPAN class="tiny">Payer/Plan</SPAN></TD>
								<TD align="left" nowrap="true">
									<SPAN class="tiny">Status</SPAN>
								</TD>
								<TD align="left" nowrap="true">
									<SPAN class="tiny">Ded</SPAN>
								</TD>
								<TD align="left" nowrap="true">
									<SPAN class="tiny">Rmng</SPAN>
								</TD>
								<TD align="left" nowrap="true">
									<SPAN class="tiny">Eff Date</SPAN>
								</TD>
								<TD align="left" nowrap="true"><SPAN class="tiny">Copay Primary</SPAN></TD>
								<TD align="left" nowrap="true"><SPAN class="tiny">Copay Spc</SPAN></TD>
								<TD align="left" nowrap="true"><SPAN class="tiny">Copay Other</SPAN></TD>
							</TR>
						</TABLE>
						<TABLE border="0" cellpadding="0" cellspacing="0" width="98%" align="center" bgcolor="white" id="acctInsTableBody" style="table-layout: fixed;">
							<COL width="50"/>
							<COL width="110"/>
							<COL width="110"/>
							<COL width="60"/>
							<COL width="50"/>
							<COL width="50"/>
							<COL width="60"/>
              <COL width="55"/>
              <COL width="55"/>
              <COL width="55"/>
							<xsl:choose>
								<xsl:when test="AccountInsurance/@DisplayOrder[.!='']">
									<xsl:for-each select="AccountInsurance">
										<xsl:sort select="@DisplayOrder" data-type="number" order="ascending"></xsl:sort>
										<xsl:if test="@PersonInsurancePlanUid[.!='']">
											<TR class="picklist" valign="baseline">
												<TD align="left" nowrap="true">
													<SPAN class="tiny">
														<xsl:value-of select="user:getInsuranceOrderName(string(@DisplayOrder))"/>
													</SPAN>
												</TD>
												<TD align="left" nowrap="true">
													<SPAN class="tiny">
														<xsl:if test="PersonInsurancePlan/@PersonUid">
                              <xsl:value-of select="PersonInsurancePlan/Person/@FullName"/>
														</xsl:if>
														<xsl:if test="PersonInsurancePlan/@CorporationUid">
															<xsl:value-of select="PersonInsurancePlan/Corporation/@Name"/>
														</xsl:if>
													</SPAN>
												</TD>
												<TD align="left" nowrap="true">
													<SPAN class="tiny">
														<xsl:value-of select="PersonInsurancePlan/InsurancePlan/InsuranceCarrier/Corporation/@Name"/>/<xsl:value-of select="PersonInsurancePlan/InsurancePlan/@Name"/>
													</SPAN>
												</TD>
												<TD align="left" nowrap="true">
													<SPAN class="tiny">
														<xsl:value-of select="PersonInsurancePlan/ListEligibilityStatus/@Name"/>
													</SPAN>
												</TD>
												<TD align="left" nowrap="true">
													<SPAN class="tiny">
														<xsl:value-of select="user:toCurrency(string(PersonInsurancePlan/@InNetworkDeductible))"/>
													</SPAN>
												</TD>
												<TD align="left" nowrap="true">
													<SPAN class="tiny">
														<xsl:value-of select="user:toCurrency(string(PersonInsurancePlan/@InNetworkRemaining))"/>
													</SPAN>
												</TD>
												<TD align="left" nowrap="true">
													<SPAN class="tiny">
														<xsl:value-of select="PersonInsurancePlan/@EligibilityEffectiveDate"/>
													</SPAN>
												</TD>
												<TD align="left" nowrap="true">
													<SPAN class="tiny">
														<xsl:value-of select="user:toCurrency(string(PersonInsurancePlan/@CopayPrimary))"/>
													</SPAN>
												</TD>
												<TD align="left" nowrap="true">
													<SPAN class="tiny">
														<xsl:value-of select="user:toCurrency(string(PersonInsurancePlan/@CopaySpecialist))"/>
													</SPAN>
												</TD>
												<TD align="left" nowrap="true">
													<SPAN class="tiny">
														<xsl:value-of select="user:toCurrency(string(PersonInsurancePlan/@CopayOther))"/>
													</SPAN>
												</TD>
											</TR>
											<TR class="picklist small" valign="baseline">
												<TD align="left" nowrap="true">
												</TD>
												<TD align="left" nowrap="true">
													<SPAN class="tiny">
														<xsl:if test="PersonInsurancePlan/@PersonUid">
															&#xa0;DOB: <xsl:value-of select="PersonInsurancePlan/Person/@Birthdate"/>
														</xsl:if>
													</SPAN>
												</TD>
												<TD colspan="8" align="left" nowrap="true">
													<SPAN class="tiny">
														&#xa0;Group ID: <xsl:value-of select="PersonInsurancePlan/@PlanGroupID"/>
													</SPAN>
												</TD>
											</TR>
											<TR class="picklist small" valign="baseline">
												<TD align="left" nowrap="true">
												</TD>
												<TD align="left" nowrap="true">
													<SPAN class="tiny">
														&#xa0;Patient Relation:<xsl:value-of select="@Relationship"/>
														<!--<span class="FindControl" BusinessObject="ListRelationshipFactory" fcReadOnly="true">
															<xsl:attribute name="fcForeignKeyUid">
																<xsl:value-of select="@RelationshipUid"/>
															</xsl:attribute>&#xa0;
														</span>-->
													</SPAN>
													<br/>
													<SPAN class="tiny">
														&#xa0;Authorize Assignment: <xsl:choose>
															<xsl:when test="PersonInsurancePlan[@AuthorizeAssignment = '1' or @AuthorizeAssignment = 'True']">Yes</xsl:when>
															<xsl:otherwise>No</xsl:otherwise>
														</xsl:choose>
													</SPAN>
												</TD>
												<TD align="left" nowrap="true">
													<SPAN class="tiny">
														&#xa0;Member ID:<xsl:value-of select="PersonInsurancePlan/@PlanMemberID"/>
													</SPAN>
													<br/>
													<SPAN class="tiny">
														<xsl:choose>
															<xsl:when test="PersonInsurancePlan/InsurancePlan[@UseCarrierAddress = '1' or @UseCarrierAddress = 'True']">
																<xsl:if test="string-length(PersonInsurancePlan/InsurancePlan/InsuranceCarrier/Corporation/Address/Address/Address1)">
																	&#xa0;<xsl:value-of select="PersonInsurancePlan/InsurancePlan/InsuranceCarrier/Corporation/Address/Address/Address1"/>
																	<br/>
																</xsl:if>
																<xsl:if test="string-length(PersonInsurancePlan/InsurancePlan/InsuranceCarrier/Corporation/Address/Address/Address2)">
																	&#xa0;<xsl:value-of select="PersonInsurancePlan/InsurancePlan/InsuranceCarrier/Corporation/Address/Address/Address2"/>
																	<br/>
																</xsl:if>
																<xsl:if test="string-length(PersonInsurancePlan/InsurancePlan/InsuranceCarrier/Corporation/Address/Address/City) or string-length(PersonInsurancePlan/InsurancePlan/InsuranceCarrier/Corporation/Address/Address/State) or string-length(PersonInsurancePlan/InsurancePlan/InsuranceCarrier/Corporation/Address/Address/Zip) or string-length(PersonInsurancePlan/InsurancePlan/InsuranceCarrier/Corporation/Address/Address/Country)">
																	&#xa0;<xsl:value-of select="PersonInsurancePlan/InsurancePlan/InsuranceCarrier/Corporation/Address/Address/City"/>, <xsl:value-of select="PersonInsurancePlan/InsurancePlan/InsuranceCarrier/Corporation/Address/Address/State"/>&#xa0;<xsl:value-of select="PersonInsurancePlan/InsurancePlan/InsuranceCarrier/Corporation/Address/Address/Zip"/>&#xa0;<xsl:value-of select="PersonInsurancePlan/InsurancePlan/InsuranceCarrier/Corporation/Address/Address/Country"/>
																</xsl:if>
															</xsl:when>
															<xsl:otherwise>
																<xsl:if test="string-length(PersonInsurancePlan/InsurancePlan/Address/Address/Address1)">
																	&#xa0;<xsl:value-of select="PersonInsurancePlan/InsurancePlan/Address/Address/Address1"/>
																	<br/>
																</xsl:if>
																<xsl:if test="string-length(PersonInsurancePlan/InsurancePlan/Address/Address/Address2)">
																	&#xa0;<xsl:value-of select="PersonInsurancePlan/InsurancePlan/Address/Address/Address2"/>
																	<br/>
																</xsl:if>
																<xsl:if test="string-length(PersonInsurancePlan/InsurancePlan/Address/Address/City) or string-length(PersonInsurancePlan/InsurancePlan/Address/Address/State) or string-length(PersonInsurancePlan/InsurancePlan/Address/Address/Zip) or string-length(PersonInsurancePlan/InsurancePlan/Address/Address/Country)">
																	&#xa0;<xsl:value-of select="PersonInsurancePlan/InsurancePlan/Address/Address/City"/>, <xsl:value-of select="PersonInsurancePlan/InsurancePlan/Address/Address/State"/>&#xa0;<xsl:value-of select="PersonInsurancePlan/InsurancePlan/Address/Address/Zip"/>&#xa0;<xsl:value-of select="PersonInsurancePlan/InsurancePlan/Address/Address/Country"/>
																</xsl:if>
															</xsl:otherwise>
														</xsl:choose>
														&#xa0;<xsl:value-of select="PersonInsurancePlan/InsurancePlan/Phone/Phone/PhoneNumber"/>
														<xsl:if test="string-length(PersonInsurancePlan/InsurancePlan/Phone2/Phone/PhoneNumber)">
															<br/>
															&#xa0;<xsl:value-of select="PersonInsurancePlan/InsurancePlan/Phone2/Phone/PhoneNumber"/>
														</xsl:if>
														<xsl:if test="string-length(PersonInsurancePlan/InsurancePlan/Phone3/Phone/PhoneNumber)">
															<br/>
															&#xa0;<xsl:value-of select="PersonInsurancePlan/InsurancePlan/Phone3/Phone/PhoneNumber"/>
														</xsl:if>
														<xsl:if test="string-length(PersonInsurancePlan/InsurancePlan/Phone4/Phone/PhoneNumber)">
															<br/>
															&#xa0;<xsl:value-of select="PersonInsurancePlan/InsurancePlan/Phone4/Phone/PhoneNumber"/>
														</xsl:if>
													</SPAN>
												</TD>
												<TD colspan="7" align="left" nowrap="true">
												</TD>
											</TR>
										</xsl:if>
									</xsl:for-each>
								</xsl:when>
								<xsl:otherwise>
								<TR bgcolor="white">
									<TD colspan="10" align="center" nowrap="true" valign="baseline">
										<SPAN class="small">(No insurance listed for this account.)</SPAN>
									</TD>
								</TR>
								</xsl:otherwise>
							</xsl:choose>
						</TABLE>
					</xsl:for-each>
				</xsl:element>
			</xsl:for-each>
      			<xsl:if test="$accountNodeCount &lt; 1">
        			<input type="button" class="blueBtn" value="Create Person Account">
          			<xsl:attribute name="onClick">
            			if(iMedica.Patient.FixPersonAccountMissing('<xsl:value-of select="//@PersonUid"/>')) init1();
          			</xsl:attribute>
        			</input>
      			</xsl:if>
		  </xsl:element> <!--printDiv-->
		</xsl:element>
	</xsl:template>
	<msxsl:script language="Jscript" implements-prefix="user">
		<![CDATA[

		function getInsuranceOrderName(sOrder)
		{
			switch (sOrder) {
				case "1": return "Primary"; break;
				case "2": return "Secondary"; break;
				case "3": return "Tertiary"; break;
				case "4": return "Quaternary"; break;
				case "5": return "Quinary"; break;
				case "6": return "Senary"; break;
				case "7": return "Septary"; break;
				case "8": return "Ogdoad"; break;
				case "9": return "Ennead"; break;
				case "10": return "Decad"; break;
				default: return sOrder + "-ary";
			}
		}

		function convertXMLDateTimeToJSDateObj(strDate)
		{
			// parse the XML datetime string: yyyy-mm-ddThh:mm:ss
			return new Date(strDate.substring(5,10) + '-' + strDate.substring(0,4) + ' ' + strDate.substring(11,16));
		}

		function convertDateToStringDate(dDate)
		{
			var theMonth = (dDate.getMonth()+1);
			var theDate = dDate.getDate();
			if (theMonth < 10) {
				theMonth = "0" + (theMonth);
			}
			if (theDate < 10) {
				theDate = "0" + theDate;
			}
			var strDate = theMonth + "/" + theDate + "/" + dDate.getFullYear().toString();
			return strDate;
		}

		function getStringDate(sXMLDateTime)
		{
			if (sXMLDateTime != "")
				return convertDateToStringDate(convertXMLDateTimeToJSDateObj(sXMLDateTime));
			return "";
		}

		function getDateOnly(strDateTime)
		{
			if (strDateTime != "")
			{
				if (parseInt(strDateTime.substr(0,strDateTime.indexOf("/"))) < 10)
				{
					strDateTime = "0" + strDateTime;
				}

				if (parseInt(strDateTime.substr(strDateTime.indexOf("/")+1,(strDateTime.indexOf("/",(strDateTime.indexOf("/")+1))-1))) < 10)
					strDateTime = strDateTime.replace("/", "/0");

				strDateTime = strDateTime.substr(0,strDateTime.indexOf(' '));
				return strDateTime;
				//return convertDateToStringDate(convertDateToJSDateObj(strDateTime));
			}
			return "";
		}

		function getStringPeriodStartDate(sXMLDateTime)
		{
			if (sXMLDateTime != "")
			    return sXMLDateTime;
			return "Past";
		}

		function getStringPeriodDate(sXMLDateTime)
		{
			if (sXMLDateTime != "")
				return sXMLDateTime;
			return "Future";
		}

		// Need to add support for .trim() manually
		String.prototype.trim = String_trim;
		function String_trim() {
			//
			// trims spaces from both ends of a string
			if(this.length > 0) {
				var start = 0;
				while(((this.charAt(start)).valueOf() == " ".valueOf()) && (start < this.length)) {
					start++;
				}
				if(start >= this.length) {
					return ""; //string contains spaces only.
				}
				var endstr = this.length - 1;
				while(((this.charAt(endstr)).valueOf() == " ".valueOf()) && (endstr >= 0)) {
					endstr--;
				}
				return this.substring(start,endstr+1);
			}
			else {
			return "" + this;
			}
		}

    function concatLastNameFirstName(strLastName, strFirstName)
    {
      var sRtn = '';
      if ((strLastName != null) && (strLastName != ''))
      {
        sRtn = strLastName;
      }
      if ((strFirstName != null) && (strFirstName != ''))
      {
        if ((sRtn != null) && (sRtn != ''))
        {
          sRtn = sRtn + ', ' + strFirstName;
        }
        else
        {
          sRtn = strFirstName;
        }
      }
      return sRtn;
    }

		function toCurrency(strSrc) {
			// returns the input string in currency format
			// returns false if not a currency or if it overflows
			// the SQL Server money datatype
			// 10/5/99, perkins
			// Instead of false, returns '' if strSrc is null

			if (strSrc == null || strSrc == '')
				return '';
			// Strip commas and dollar signs
			var re = new RegExp('[,$]', 'ig');
			theMoney = ('' + strSrc).replace(re, '').trim();
			// Convert parens format for negative values to - format
			if ((theMoney.charAt(0) == '(') && (theMoney.charAt(theMoney.length - 1) == ')')) {
				theMoney = '-' + theMoney.substring(1, theMoney.length - 1);
			}
			// Exclude the blank string and scientific notation
			if (theMoney == '' || theMoney.toUpperCase().indexOf('E') > -1) {
				return '';
			}
			// 920000000000000 ~ the limit of the currency datatype in SQL server
			if (isNaN(theMoney) || theMoney > 920000000000000) {
				return '';
			}
			// Format the number
			var thePrefix = '$';
			var theSuffix = '';
			if (theMoney.charAt(0) == '-') {
				thePrefix = '(' + thePrefix;
				theSuffix = theSuffix + ')';
				theMoney = theMoney.substring(1, theMoney.length);
			}
			theMoney = '' + (Math.round(100*parseFloat(theMoney))/100)
			var theCents = '0' + (Math.round((parseFloat(theMoney) % 1)*100));
			theCents = '.' + theCents.substring(theCents.length - 2, theCents.length);
			var theDollars = '' + (Math.floor(parseFloat(theMoney)));
			// Add commas
			var theIdx = theDollars.length - 3;
			while (theIdx > 0) {
				theDollars = theDollars.substring(0, theIdx) + ',' + theDollars.substring(theIdx, theDollars.length);
				theIdx += -3;
			}
			// put it all together
			return thePrefix + theDollars + theCents + theSuffix;
		}

    function UCString( strID) {
     var retVal = strID.toUpperCase() ;
    return retVal ;
    }
    function altString(strPlanMemberID, strEligibilitySubscriberID, strOtherPayerTypeCode) {
      var retVal = "" ;
     retVal += 'Eligibility Active Coverage\r\n\r\n';
      if ( strPlanMemberID.toUpperCase() != strEligibilitySubscriberID.toUpperCase() ) {
        retVal += 'Plan Member ID (' + strPlanMemberID.toUpperCase() + ') does not match eligibility Subscriber ID (' + strEligibilitySubscriberID.toUpperCase() + ')\r\n\r\n' ;
      }

      if (strOtherPayerTypeCode) {
			  retVal += 'Eligibility or benefit code indicates contact the following entity for other or additional benefit information\r\n' ;
 			  switch (strOtherPayerTypeCode) {
            case "12": retVal += "12 Medicare Secondary Working Aged Beneficiary or Spouse with Employer Group Health Plan"; break;
            case "13": retVal += "13 Medicare Secondary End-Stage Renal Disease Beneficiary in the Mandated Coordination Period with an Employer’s Group Health Plan"; break;
            case "14": retVal += "14 Medicare Secondary, No-fault Insurance including Auto is Primary"; break;
            case "15": retVal += "15 Medicare Secondary Worker’s Compensation"; break;
            case "16": retVal += "16 Medicare Secondary Public Health Service (PHS)or Other Federal Agency"; break;
            case "41": retVal += "41 Medicare Secondary Black Lung"; break;
            case "42": retVal += "42 Medicare Secondary Veteran’s Administration"; break;
            case "43": retVal += "43 Medicare Secondary Disabled Beneficiary Under Age 65 with Large Group Health Plan (LGHP)"; break;
            case "47": retVal += "47 Medicare Secondary, Other Liability Insurance is Primary"; break;
            case "AP": retVal += "AP Auto Insurance Policy"; break;
            case "C1": retVal += "C1 Commercial"; break;
            case "CO": retVal += "CO Consolidated Omnibus Budget Reconciliation Act (COBRA)"; break;
            case "CP": retVal += "CP Medicare Conditionally Primary"; break;
            case "D" : retVal += "D  Disability"; break;
            case "DB": retVal += "DB Disability Benefits"; break;
            case "EP": retVal += "EP Exclusive Provider Organization"; break;
            case "FF": retVal += "FF Family or Friends"; break;
            case "GP": retVal += "GP Group Policy"; break;
            case "HM": retVal += "HM Health Maintenance Organization (HMO)"; break;
            case "HN": retVal += "HN Health Maintenance Organization (HMO) - Medicare Risk"; break;
            case "HS": retVal += "HS Special Low Income Medicare Beneficiary"; break;
            case "IN": retVal += "IN Indemnity"; break;
            case "IP": retVal += "IP Individual Policy"; break;
            case "LC": retVal += "LC Long Term Care"; break;
            case "LD": retVal += "LD Long Term Policy"; break;
            case "LI": retVal += "LI Life Insurance"; break;
            case "LT": retVal += "LT Litigation"; break;
            case "MA": retVal += "MA Medicare Part A"; break;
            case "MB": retVal += "MB Medicare Part B"; break;
            case "MC": retVal += "MC Medicaid"; break;
            case "MH": retVal += "MH Medigap Part A"; break;
            case "MI": retVal += "MI Medigap Part B"; break;
            case "MP": retVal += "MP Medicare Primary"; break;
            case "OT": retVal += "OT Other"; break;
            case "PE": retVal += "PE Property Insurance - Personal"; break;
            case "PL": retVal += "PL Personal"; break;
            case "PP": retVal += "PP Personal Payment (Cash - No Insurance)"; break;
            case "PR": retVal += "PR Preferred Provider Organization (PPO)"; break;
            case "PS": retVal += "PS Point of Service (POS)"; break;
            case "QM": retVal += "QM Qualified Medicare Beneficiary"; break;
            case "RP": retVal += "RP Property Insurance - Real"; break;
            case "SP": retVal += "SP Supplemental Policy"; break;
            case "TF": retVal += "TF Tax Equity Fiscal Responsibility Act (TEFRA)"; break;
            case "WC": retVal += "WC Workers Compensation"; break;
            case "WU": retVal += "WU Wrap Up Policy"; break ;
            default: break ;
          }
			}

      return retVal ;
    }

		]]>
	</msxsl:script>
</xsl:stylesheet>
