﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" exclude-result-prefixes="msxsl">
    <xsl:output method="xml" indent="yes"/>

    <xsl:variable name="itmCount" select="0" />
    
    <xsl:template match="/">
        <encounters type="CMS-1500">
            <encounter seq="1">
                <xsl:call-template name="fld-00" />
                <xsl:call-template name="fld-01" />
                <xsl:apply-templates select="Visit/PatientNames" />
                <xsl:call-template name="fld-03" />
                <fld-04 last="" first="" middle="" />
                <xsl:call-template name="fld-05" />
                <fld-06 self="" spouse="" child="" other="" />
                <fld-07 addr="" city="" state="" zip="" phone="" />
                <fld-08 single="" married="" other="" full-time="" part-time="" />
                <fld-09 last="" first="" middle="" policy="" dobm="" dobd="" doby="" sex-m="" sex-f="" />
                <fld-10 employ-yes="" employ-no="" auto-yes="" auto-no="" auto-state="" oth-yes="" oth-no="" />
                <fld-11 policy="" m="" d="" y="" sex-m="" sex-f="" emp-name="" plan-name="" oth-yes="" oth-no="" />
                <fld-12 signed="" m="" d="" y="" />
                <fld-13 signed="" />
                <xsl:call-template name="fld-14" />
                <fld-15 m="" d="" y="" qual="" />
                <fld-16 fm="" fd="" fy="" tm="" td="" ty="" />
                <xsl:call-template name="fld-17" />
                <fld-18 fm="" fd="" fy="" tm="" td="" ty="" />
                <fld-19 area1="" area2="" />
                <fld-20 out-yes="" out-no="" charges="" />
                <xsl:call-template name="fld-21" />
                <fld-22 resub="" org="" />
                <fld-23 prior="" />
                <xsl:call-template name="fld-24" />
                <fld-25 taxid="" ssn="" ein="" />
                <fld-26 acct-num="" />
                <fld-27 asg-yes="" asg-no="" />
                <fld-28 total="" />
                <fld-29 paid="" />
                <fld-30 due="" />
                <fld-31 signed="" m="" d="" y="" name="" />
                <xsl:call-template name="fld-32" />
                <fld-33 name="" addr="" city="" state="" zip="" phone="" npi="" id-num="" />
            </encounter>
        </encounters>    
    </xsl:template>
  
  <xsl:template name="fld-00">
    <xsl:element name="fld-00">
      <xsl:attribute name="payer">
        <xsl:value-of select="Visit/VisitPayerName"/>
      </xsl:attribute>
      <xsl:attribute name="addr" />
      <xsl:attribute name="city" />
      <xsl:attribute name="state" />
      <xsl:attribute name="zip" />
      <xsl:attribute name="payer-id">
        <xsl:value-of select="Visit/VisitPayerExternalId"/>
      </xsl:attribute>
    </xsl:element>
  </xsl:template>
  
  
  <xsl:template name="fld-01">
    <xsl:element name="fld-01">
      <xsl:choose>
        <xsl:when test="Visit/VisitPayerInsuranceAccountType = 'MA' or Visit/VisitPayerInsuranceAccountType = 'MB'">
          <xsl:attribute name="medicare">
            <xsl:text>1</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="medicaid" />
          <xsl:attribute name="champus" />
          <xsl:attribute name="champva" />
          <xsl:attribute name="group" />
          <xsl:attribute name="feca" />
          <xsl:attribute name="oth" />
        </xsl:when>
        <xsl:when test="Visit/VisitPayerInsuranceAccountType = 'MC'">
          <xsl:attribute name="medicare" />
          <xsl:attribute name="medicaid">
            <xsl:text>1</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="champus" />
          <xsl:attribute name="champva" />
          <xsl:attribute name="group" />
          <xsl:attribute name="feca" />
          <xsl:attribute name="oth" />
        </xsl:when>
        <xsl:when test="Visit/VisitPayerInsuranceAccountType = 'CH'">
          <xsl:attribute name="medicare" />
          <xsl:attribute name="medicaid" />
          <xsl:attribute name="champus">
            <xsl:text>1</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="champva" />
          <xsl:attribute name="group" />
          <xsl:attribute name="feca" />
          <xsl:attribute name="oth" />
        </xsl:when>
        <xsl:when test="Visit/VisitPayerInsuranceAccountType = 'VA'">
          <xsl:attribute name="medicare" />
          <xsl:attribute name="medicaid" />
          <xsl:attribute name="champus" />
          <xsl:attribute name="champva">
            <xsl:text>1</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="group" />
          <xsl:attribute name="feca" />
          <xsl:attribute name="oth" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="medicare" />
          <xsl:attribute name="medicaid" />
          <xsl:attribute name="champus" />
          <xsl:attribute name="champva" />
          <xsl:attribute name="group" />
          <xsl:attribute name="feca" />
          <xsl:attribute name="oth">
            <xsl:text>1</xsl:text>
          </xsl:attribute>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:attribute name="ins-id">
        <xsl:value-of select="Visit/InsurancePlanMemberID"/>
      </xsl:attribute>
      <xsl:attribute name="auto" />
      <xsl:attribute name="wc" />
      <xsl:attribute name="com" />
      <xsl:attribute name="fbcs" />
    </xsl:element>
  </xsl:template>

  <xsl:template name="fld-03">
        <xsl:element name="fld-03">
            <xsl:apply-templates select="Visit/PatientDOB" />
            <xsl:apply-templates select="Visit/PatientGenderInitial" />
        </xsl:element>
    </xsl:template>

    <xsl:template name="fld-05">
        <xsl:element name="fld-05">
            <xsl:choose>
                <xsl:when test="count(Visit/PatientPrimaryAddresses) > 0">
                    <xsl:apply-templates select="Visit/PatientPrimaryAddresses" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="addr" />
                    <xsl:attribute name="city" />
                    <xsl:attribute name="state" />
                    <xsl:attribute name="zip" />
                </xsl:otherwise>
            </xsl:choose>
            <xsl:attribute name="phone" />
        </xsl:element>
    </xsl:template>

    <xsl:template name="fld-14">
        <xsl:element name="fld-14">
            <xsl:apply-templates select="Visit/VisitDate" />
            <xsl:attribute name="illness" />
            <xsl:attribute name="accident" />
            <xsl:attribute name="lmp" />
        </xsl:element>
    </xsl:template>

    <xsl:template name="fld-17">
        <xsl:element name="fld-17">
            <xsl:apply-templates select="Visit/ProviderNames" />
            <xsl:attribute name="id-qual" />
            <xsl:attribute name="id-num" />
            <xsl:attribute name="npi">
                <xsl:value-of select="Visit/ProviderIdentifierNPI"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>
    
    <xsl:template name="fld-21">
        <xsl:element name="fld-21">                   

          <xsl:choose>
            <xsl:when test="Visit/VisitPayerName[@ICD10Payer = 'True']">
              <xsl:attribute name="dx-version">ABK</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="dx-version">BK</xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
                <xsl:when test="count(Visit/DXCodeValidation1) > 0">
                    <xsl:apply-templates select="Visit/DXCodeValidation1" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="dx1" />
                </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="count(Visit/DXCodeValidation2) > 0">
                    <xsl:apply-templates select="Visit/DXCodeValidation2" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="dx2" />
                </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="count(Visit/DXCodeValidation3) > 0">
                    <xsl:apply-templates select="Visit/DXCodeValidation3" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="dx3" />
                </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="count(Visit/DXCodeValidation4) > 0">
                    <xsl:apply-templates select="Visit/DXCodeValidation4" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="dx4" />
                </xsl:otherwise>
            </xsl:choose>
          <xsl:choose>
            <xsl:when test="count(Visit/DXCodeValidation5) > 0">
              <xsl:apply-templates select="Visit/DXCodeValidation5" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="dx5" />
            </xsl:otherwise>
          </xsl:choose>
          <xsl:choose>
            <xsl:when test="count(Visit/DXCodeValidation6) > 0">
              <xsl:apply-templates select="Visit/DXCodeValidation6" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="dx6" />
            </xsl:otherwise>
          </xsl:choose>
          <xsl:choose>
            <xsl:when test="count(Visit/DXCodeValidation7) > 0">
              <xsl:apply-templates select="Visit/DXCodeValidation7" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="dx7" />
            </xsl:otherwise>
          </xsl:choose>
          <xsl:choose>
            <xsl:when test="count(Visit/DXCodeValidation8) > 0">
              <xsl:apply-templates select="Visit/DXCodeValidation8" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="dx8" />
            </xsl:otherwise>
          </xsl:choose>
          <xsl:choose>
            <xsl:when test="count(Visit/DXCodeValidation9) > 0">
              <xsl:apply-templates select="Visit/DXCodeValidation9" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="dx9" />
            </xsl:otherwise>
          </xsl:choose>
          <xsl:choose>
            <xsl:when test="count(Visit/DXCodeValidation10) > 0">
              <xsl:apply-templates select="Visit/DXCodeValidation10" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="dx10" />
            </xsl:otherwise>
          </xsl:choose>
          <xsl:choose>
            <xsl:when test="count(Visit/DXCodeValidation11) > 0">
              <xsl:apply-templates select="Visit/DXCodeValidation11" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="dx11" />
            </xsl:otherwise>
          </xsl:choose>
          <xsl:choose>
            <xsl:when test="count(Visit/DXCodeValidation12) > 0">
              <xsl:apply-templates select="Visit/DXCodeValidation12" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="dx12" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:element>
    </xsl:template>

    <xsl:template name="fld-24">
        <fld-24>
            <xsl:apply-templates select="Visit/ServicesPerformedInternal" />
        </fld-24>
    </xsl:template>

  <xsl:template name="fld-32">
    <xsl:element name="fld-32">
      <xsl:attribute name="name">
        <xsl:value-of select="Visit/VisitServiceSiteName"/>
      </xsl:attribute>
      <xsl:attribute name="addr" />
      <xsl:attribute name="city" />
      <xsl:attribute name="state" />
      <xsl:attribute name="zip">
        <xsl:value-of select="Visit/VisitServiceSiteAddresses/VisitServiceSiteAddressZip" />
      </xsl:attribute>
      <xsl:attribute name="npi" />
      <xsl:attribute name="id-num" />
      <xsl:attribute name="clia" />
      <xsl:attribute name="mammo" />
    </xsl:element>
  </xsl:template>

  <xsl:template match="Visit/PatientNames">
        <xsl:element name="fld-02">
            <xsl:attribute name="last" >
                <xsl:value-of select="PatientLastName"/>
            </xsl:attribute>
            <xsl:attribute name="first" >
                <xsl:value-of select="PatientFirstName"/>
            </xsl:attribute>
            <xsl:attribute name="middle" >
                <xsl:value-of select="PatientMiddleName"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match="Visit/PatientDOB">
        <xsl:apply-templates select="MonthDayYear" />
    </xsl:template>

    <xsl:template match="Visit/PatientGenderInitial">
        <xsl:attribute name="sex-m">
            <xsl:choose>
                <xsl:when test="../PatientGenderInitial = 'M'">
                    <xsl:text>1</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:attribute>
        <xsl:attribute name="sex-f">
            <xsl:choose>
                <xsl:when test="../PatientGenderInitial = 'F'">
                    <xsl:text>1</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="Visit/PatientPrimaryAddresses">
        <xsl:attribute name="addr">
            <xsl:value-of select="PatientPrimaryAddressLine1" />
            <xsl:text> </xsl:text>
            <xsl:value-of select="PatientPrimaryAddressLine2" />
        </xsl:attribute>
        <xsl:attribute name="city">
            <xsl:value-of select="PatientPrimaryAddressCity" />
        </xsl:attribute>
        <xsl:attribute name="state">
            <xsl:value-of select="PatientPrimaryAddressState" />
        </xsl:attribute>
        <xsl:attribute name="zip">
            <xsl:value-of select="PatientPrimaryAddressZip" />
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="Visit/PatientPhones">
        <xsl:attribute name="phone">
            <xsl:value-of select="PatientMainPhone" />
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="Visit/VisitDate">
        <xsl:apply-templates select="MonthDayYear" />
    </xsl:template>
    
    <xsl:template match="MonthDayYear">
        <xsl:param name="prefix" />
        <xsl:choose>
            <xsl:when test="string-length($prefix) > 0">
                <xsl:attribute name="{concat($prefix, 'm')}">
                    <xsl:value-of select="substring(., 1, 2)"/>
                </xsl:attribute>
                <xsl:attribute name="{concat($prefix, 'd')}">
                    <xsl:value-of select="substring(., 4, 2)"/>
                </xsl:attribute>
                <xsl:attribute name="{concat($prefix, 'y')}">
                    <xsl:value-of select="substring(., 7, 4)"/>
                </xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="m">
                    <xsl:value-of select="substring(., 1, 2)"/>
                </xsl:attribute>
                <xsl:attribute name="d">
                    <xsl:value-of select="substring(., 4, 2)"/>
                </xsl:attribute>
                <xsl:attribute name="y">
                    <xsl:value-of select="substring(., 7, 4)"/>
                </xsl:attribute>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="Visit/DXCodeValidation1">
        <xsl:attribute name="dx1">
            <xsl:value-of select="." />
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="Visit/DXCodeValidation2">
        <xsl:attribute name="dx2">
            <xsl:value-of select="." />
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="Visit/DXCodeValidation3">
        <xsl:attribute name="dx3">
            <xsl:value-of select="." />
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="Visit/DXCodeValidation4">
        <xsl:attribute name="dx4">
            <xsl:value-of select="." />
        </xsl:attribute>
    </xsl:template>

  <xsl:template match="Visit/DXCodeValidation5">
    <xsl:attribute name="dx5">
      <xsl:value-of select="." />
    </xsl:attribute>
  </xsl:template>

  <xsl:template match="Visit/DXCodeValidation6">
    <xsl:attribute name="dx6">
      <xsl:value-of select="." />
    </xsl:attribute>
  </xsl:template>

  <xsl:template match="Visit/DXCodeValidation7">
    <xsl:attribute name="dx7">
      <xsl:value-of select="." />
    </xsl:attribute>
  </xsl:template>

  <xsl:template match="Visit/DXCodeValidation8">
    <xsl:attribute name="dx8">
      <xsl:value-of select="." />
    </xsl:attribute>
  </xsl:template>

  <xsl:template match="Visit/DXCodeValidation9">
    <xsl:attribute name="dx9">
      <xsl:value-of select="." />
    </xsl:attribute>
  </xsl:template>

  <xsl:template match="Visit/DXCodeValidation10">
    <xsl:attribute name="dx10">
      <xsl:value-of select="." />
    </xsl:attribute>
  </xsl:template>

  <xsl:template match="Visit/DXCodeValidation11">
    <xsl:attribute name="dx11">
      <xsl:value-of select="." />
    </xsl:attribute>
  </xsl:template>

  <xsl:template match="Visit/DXCodeValidation12">
    <xsl:attribute name="dx12">
      <xsl:value-of select="." />
    </xsl:attribute>
  </xsl:template>

  <xsl:template match="Visit/ProviderNames">
        <xsl:attribute name="name">
            <xsl:value-of select="ProviderFullName"/>
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="ServicesPerformedInternal">
        <xsl:element name="{concat('itm0', position())}">
            <xsl:apply-templates select="/Visit/VisitDate/MonthDayYear" >
                <xsl:with-param name="prefix" select="'f'" />
            </xsl:apply-templates>
            <xsl:apply-templates select="/Visit/VisitDate/MonthDayYear" >
                <xsl:with-param name="prefix" select="'t'" />
            </xsl:apply-templates>
            <xsl:attribute name="pos" >
              <xsl:value-of select="/Visit/ServiceSitePOS"/>
            </xsl:attribute>
            <xsl:attribute name="cpt" >
                <xsl:value-of select="CPT"/>
            </xsl:attribute>
            <xsl:call-template name="Modifier" >
                <xsl:with-param name="nameof" select="'m1'" />
                <xsl:with-param name="valueof" select="Modifier1" />
            </xsl:call-template>
            <xsl:call-template name="Modifier" >
                <xsl:with-param name="nameof" select="'m2'" />
                <xsl:with-param name="valueof" select="Modifier2" />
            </xsl:call-template>
            <xsl:call-template name="Modifier" >
                <xsl:with-param name="nameof" select="'m3'" />
                <xsl:with-param name="valueof" select="Modifier3" />
            </xsl:call-template>
            <xsl:call-template name="Modifier" >
                <xsl:with-param name="nameof" select="'m4'" />
                <xsl:with-param name="valueof" select="Modifier4"  />
            </xsl:call-template>
            <xsl:attribute name="ptr">
                <xsl:apply-templates select="LinkedDXs" />
            </xsl:attribute>
            <xsl:attribute name="charge">
            </xsl:attribute>
            <xsl:attribute name="unit">
                <xsl:value-of select="Unit"/>
            </xsl:attribute>
            <xsl:attribute name="epsdt">
            </xsl:attribute>
            <xsl:attribute name="emg">
            </xsl:attribute>
            <xsl:attribute name="id-qual">
            </xsl:attribute>
            <xsl:attribute name="id-num">
            </xsl:attribute>
            <xsl:attribute name="npi">
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match="LinkedDXs">
            <xsl:apply-templates select="LinkedDX" />
    </xsl:template>

    <xsl:template match="LinkedDX">
        <xsl:choose>
            <xsl:when test="position() = 1">
                <xsl:value-of select="."/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>,</xsl:text>
              <xsl:value-of select="."/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="Modifier">
        <xsl:param name="nameof" />
        <xsl:param name="valueof" />
        <xsl:choose>
            <xsl:when test="string-length($valueof) > 0">
                <xsl:attribute name="{$nameof}">
                    <xsl:value-of select="$valueof"/>
                </xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="{$nameof}" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
