﻿<?xml version="1.0"?>
<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:msxsl="urn:schemas-microsoft-com:xslt" 
  xmlns:user="urn:schemas-imedica.com:prm">
  
  <xsl:output method="html" encoding="UTF-8"/>
  <xsl:template match="/">

    <table border="0" cellpadding="1" cellspacing="0" align="center" style="table-layout: fixed;" width="98%" class="small">
      <col width="150px"/>
      <col width="100px"/>
      <thead>
        <tr>
          <td>Target Superbill</td>
          <td>Service Date</td>
          <td>Patient (Account)</td>
          <td>Financial Center</td>
          <td>Service Site</td>
          <td>Provider</td>
          <td>Procedure</td>
          <td>Units</td>
          <td>Modifiers</td>
          <td>Source Superbill</td>
          <td>Source Zero'd</td>
        </tr>
      </thead>

      <xsl:for-each select="ROOT/CombinedSuperbillConfirmationRow">
        <tr>
          <xsl:if test="position() mod 2 = 0">
            <xsl:attribute name="class">oddrow</xsl:attribute>
          </xsl:if>
          <xsl:if test="position() mod 2 = 1">
            <xsl:attribute name="class">evenrow</xsl:attribute>
          </xsl:if>
          <td>
            <xsl:value-of select="@TargetExternalID"/>
          </td>
          <td>
            <xsl:value-of select="@ServiceDate"/>
          </td>
          <td>
            <xsl:value-of select="@PatientAccount"/>
          </td>
          <td>
            <xsl:value-of select="@FinancialCenter"/>
          </td>
          <td>
            <xsl:value-of select="@ServiceSite"/>
          </td>
          <td>
            <xsl:value-of select="@Provider"/>
          </td>
          <td>
            <xsl:value-of select="@ProcedureCode"/>
          </td>
          <td>
            <xsl:value-of select="@Units"/>
          </td>
          <td>
            <xsl:value-of select="@Modifiers"/>
          </td>
          <td>
            <xsl:value-of select="@SourceExternalID"/>
          </td>
          <td>
            <xsl:value-of select="@SourceZerod"/>
          </td>
        </tr>
      </xsl:for-each>
      
    </table>
    
  </xsl:template>
  <msxsl:script language="Jscript" implements-prefix="user">
		<![CDATA[
    
    function convertXMLDateTimeToJSDateObj(strDate)
		{
			// parse the XML datetime string: yyyy-mm-ddThh:mm:ss
			return new Date(strDate.substring(5,10) + '-' + strDate.substring(0,4) + ' ' + strDate.substring(11,16));
		}

		function convertDateToStringDate(dDate)
		{
			var theMonth = (dDate.getMonth()+1);
			var theDate = dDate.getDate();
			if (theMonth < 10) {
				theMonth = "0" + (theMonth);
			}
			if (theDate < 10) {
				theDate = "0" + theDate;
			}
			var strDate = theMonth + "/" + theDate + "/" + dDate.getFullYear().toString();
			return strDate;
		}

		function getStringDate(sXMLDateTime)
		{
			if (sXMLDateTime != "")
				return convertDateToStringDate(convertXMLDateTimeToJSDateObj(sXMLDateTime));
			return "";
		}

	]]>
  </msxsl:script>

</xsl:stylesheet>