function fnInit()
{
	UpdatePaymentDisplay();
	ShowPlanNotes();
	ShowFollowUpInfo();
	CreatePrintFormsUserInterface();
}

function ShowPlanNotes()
{
	var sHTML = iMedica.Checkout.SpecificInstructionHTML();
	if (sHTML != "")
	{
		tbSpecificInstruction.style.display = '';
		spanSpecificInstruction.outerHTML = sHTML;
	}

	var sHTML2 = iMedica.Checkout.CommentRecommendationHTML();
	if (sHTML2 != "")
	{
		tbCommentRecommendation.style.display = '';
		spanCommentRecommendation.outerHTML = sHTML2;
	}
}

function ShowFollowUpInfo()
{
	var sHTML = iMedica.Checkout.FollowUpHTML();
    var appointmentUid = iMedica.Checkout.AppointmentUid;
	if (sHTML != "")
	{
		tbFollowUp.style.display = '';
		spanVisitPlan.outerHTML = sHTML;
		divBody.innerHTML = iMedica.Appointments.DisplayFutureAppointments(appointmentUid);
		
		divRefer.innerHTML = iMedica.Checkout.GetReferrals();
		
	}
}

function addAppointment(sCalendarUid, sPatientUid, iApptFindValue, sApptFindTimeFrame, sVisitUid, sRecallUid)
{
	if (iMedica.Appointment.AddAppointmentJSCheckout(sCalendarUid, sPatientUid, iApptFindValue, sApptFindTimeFrame, sVisitUid, sRecallUid))
	{
		iMedica.Checkout.LoadData();
		ShowFollowUpInfo();
	}
}

function editAppointment(sAppointmentUid)
{
	if (iMedica.Appointment.EditAppointmentModalDialog(sAppointmentUid))
	{
		iMedica.Checkout.LoadData();
		ShowFollowUpInfo();
	}
}

function UpdatePaymentDisplay()
{
    spanAccount.innerText = iMedica.Checkout.AccountBalanceAll;
    spanAccountPayment.innerText = iMedica.Checkout.AccountPayment;
    if (spanAccountPayment.innerText == "")
		tdAccountPayment.style.visibility = "hidden";
	else
		tdAccountPayment.style.visibility = "visible";
		
    spanPatientBalance.innerText = iMedica.Checkout.PersonBalanceAll;
    spanChargeEstimate.innerText = iMedica.Checkout.ChargeEstimate;
    if (spanChargeEstimate.innerText == "")
        tdChargeEstimate.style.visibility = "hidden";
    else
        tdChargeEstimate.style.visibility = "visible";

	spanCopay.innerText = iMedica.Checkout.Copay;
	spanVisitPayment.innerText = iMedica.Checkout.VisitPayment;
	if (spanVisitPayment.innerText == "")
		tdVisitPayment.style.visibility = "hidden";
	else
		tdVisitPayment.style.visibility = "visible";
}

function ShowChargeEstimate() {
    iMedica.Checkout.ShowChargeEstimate();
}

function UpdatePayment()
{
    var retVal = iMedica.Checkout.EditAppointmentAccount();
    iMedica.Checkout.LoadData();
    UpdatePaymentDisplay();
	if (retVal) {
		CreatePrintFormsUserInterface();
	}
}

function CreatePrintFormsUserInterface()
{
	var html = "<table width='100%'>" + iMedica.Checkout.CreatePrintFormsUserInterface() + "</table>";
	DynamicPrintoutUI.innerHTML = html;
}

var sPrintouts;

function printForms() 
{
	var IPrintout = document.body.all("IPrintout");
	sPrintouts = "";
	traverseCollection(IPrintout, addSPrintout, null);
	iMedica.Checkout.PrintPrintouts(sPrintouts, DynamicPrintoutUI.innerHTML);
}

function generateDocuments() 
{
	iMedica.Checkout.GenerateDocuments();
}

function addSPrintout(elem) 
{
	if(elem != null && elem.firstChild.checked) 
	{
		if(sPrintouts != null && sPrintouts.length > 0)
			sPrintouts += ",";
		sPrintouts+=elem.name;
	}
}

//All this does is run a function for each item in the collection.
function traverseCollection(collection,elementOperator,arg) 
{
		if(collection != null)
			if(collection.length > 0)
				for(var i = 0; i < collection.length; i++) elementOperator(collection[i],arg);
			else
				elementOperator(collection,arg);
}

// Bug #21178 - Need Patient Plan Declined button.  
function PatientPlan_Click(objInput)
{
    var elementID = "";
    elementID = objInput.id;
    var checkedFlag = "";
    checkedFlag = objInput.checked;
    iMedica.Checkout.PatienPlanClick(elementID, checkedFlag);
}
