﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" exclude-result-prefixes="msxsl">
    <xsl:output method="html" indent="yes" version="4.01" encoding="ISO-8859-1" doctype-public="-//W3C//DTD HTML 4.01//EN"/>

    <!--  AlphaII / Megas proprietary document -->

    <xsl:variable name="title">
        <xsl:choose>
            <xsl:when test="reporterrors/job/number">
                Claim Scrub Job:  <xsl:value-of select="reporterrors/job/number"/>
            </xsl:when>
            <xsl:otherwise>Clinical Document</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

    <xsl:template match="@* | node()">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="reporterrors">
        <html>
            <head>
                <!-- <meta name='Generator' content='&CDA-Stylesheet;'/> -->
                <xsl:comment>
                    Do NOT edit this HTML directly, it was generated via an XSLt
                    transformation from the original release 2 CDA Document.
                </xsl:comment>
                <title>
                    <xsl:value-of select="$title"/>
                </title>
                <style type='text/css'>
                    body     {font-size: 10pt; font-family: Arial,Verdana,Geneva,sans-serif; color: #000000;}
                    p     {margin-left:0.25in;margin-top:0in;margin-bottom:0in;margin-right=0.15in;text-indent:-0.25in;font-size: 10pt; font-family: Arial,Verdana,Geneva,sans-serif; color: #000000;}
                    a     {color: blue}
                    h4     {font-size: 12pt; font-family: Arial,Verdana,Geneva,sans-serif; color: #000000;font-weight: bold; text-align:center;}
                    th   {font-size: 10pt; background:silver; font-family: Arial,Verdana,Geneva,sans-serif;font-weight: normal; text-align:left;}
                    td  {font-size: 10pt; font-family: Arial,Verdana,Geneva,sans-serif; color: #000000;;font-weight: normal; text-align:left;}
                    .text_bold    {font-size: 10pt; font-family: Arial,Verdana,Geneva,sans-serif; color:#000000; font-weight: bold; text-align:left; }
                    .text_abnormal  {font-size: 10pt; font-family: Arial,Verdana,Geneva,sans-serif; color:#FF0000; font-weight: normal; text-align:left;}
                    .text_italic {font-size: 10pt; font-family: Arial,Verdana,Geneva,sans-serif; color: #000000;font-style:italic; text-align:left;}
                    .text_normal  {font-size: 10pt; font-family: Arial,Verdana,Geneva,sans-serif; color: #000000;font-weight: normal; text-align:left;}
                    .pe_system    {font-size: 10pt; font-family: Arial,Verdana,Geneva,sans-serif; color:#000000; font-weight: bold; text-align:left;text-decoration: underline;}
                    .pe_subsystem    {font-size: 10pt; font-family: Arial,Verdana,Geneva,sans-serif; color:#000000; font-weight: normal; text-align:left;text-decoration: underline;}
                    .pe_symptom  {font-size: 10pt; font-family: Arial,Verdana,Geneva,sans-serif; color: #000000;font-weight: normal; text-align:left;}
                    .pe_normalfinding  {font-size: 10pt; font-family: Arial,Verdana,Geneva,sans-serif; color: #000000;font-weight: normal; text-align:left;}
                    .pe_abnormalfinding  {font-size: 10pt; font-family: Arial,Verdana,Geneva,sans-serif; color:#000000; font-weight: bold; text-align:left; }
                </style>
                <iMedica External='iMedica.Prm.Client.Web.External.FNC' />
                <script src="../Web/iMedica.js" language="JavaScript"></script>
                <style type='text/css'>P.breakhere {page-break-before: always}</style>
            </head>
            <body>

                <h2 align="center">
                    <xsl:value-of select="$title"/>
                </h2>
                <hr/>
                <table width='100%'>
                    <tr>
                        <td width='15%' valign="top">
                            <b>
                                <xsl:text>Patient: </xsl:text>
                            </b>
                        </td>
                        <td width='35%' valign="top">
                            <xsl:value-of select="/reporterrors/file/batch/claim/patientname" />
                         </td>
                        <td width='15%' align='right' valign="top">
                            <b>
                                <xsl:text>Birthdate: </xsl:text>
                            </b>
                        </td>
                        <td width='35%' valign="top">
                            <xsl:value-of select="/reporterrors/file/batch/claim/patientdob" />
                        </td>
                    </tr>

                    <tr>
                        <td width='15%' valign="top">
                            <b>
                            <xsl:text>Billed Amount: </xsl:text>
                            </b>
                        </td>
                        <td width='35%' valign="top">
                            <xsl:value-of select="/reporterrors/file/batch/claim/claimbilledamount" />
                        </td>
                        <td width='15%' align='right' valign="top">
                            <b>
                            <xsl:text>Reference Provider: </xsl:text>
                            </b>
                        </td>
                        <td width='35%' valign="top">
                            <xsl:value-of select="/reporterrors/file/batch/claim/claimrefprovider" />
                        </td>
                    </tr>
                </table>
                <xsl:apply-templates select="/reporterrors/file/batch/claim/claimerrors" />
                <xsl:apply-templates select="/reporterrors/file/batch/claim/items" />
                <xsl:apply-templates select="/reporterrors/summary" />
            </body>
            </html>
    </xsl:template>

    <xsl:template match="/reporterrors/file/batch/claim/claimerrors">
        <h3 align="center">
            Error Review
        </h3>
        <hr/>
        <table width="100%">
            <tr>
                <th width="10%">Error Code</th>
                <th width="40%">Message</th>
                <th width="10%">Action</th>
                <th width="10%">Additional Information</th>
                <th width="10%">Category</th>
            </tr>
            <xsl:apply-templates select="claimerror" />
        </table>
    </xsl:template>

    <xsl:template match="claimerror">
        <tr>
            <td width="10%" align="top">
                <xsl:value-of select="claimerrorcode"/>
            </td>
            <td width="40%" align="top">
                <xsl:value-of select="claimerrormsg"/>
            </td>
            <td width="10%" align="top">
                <xsl:value-of select="claimerroraction"/>
            </td>
            <td width="10%" align="top">
                <xsl:value-of select="claimerrordata"/>
            </td>
            <td width="10%" align="top">
                <xsl:value-of select="claimerrorcategory"/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="/reporterrors/file/batch/claim/items">
        <h3 align="center">
            Errors By Procedure
        </h3>
        <hr/>
        <table width="100%">
            <tr>
                <th width="10%">Procedure</th>
                <th width="10%">Related Diagnosis</th>
                <th width="40%">Error Codes</th>
            </tr>
            <xsl:apply-templates select="item" />
        </table>
    </xsl:template>

    <xsl:template match="item">
        <tr>
            <td width="10%" align="top">
                <xsl:value-of select="cpt"/>
            </td>
            <td width="10%" align="top">
                <xsl:value-of select="icd"/>
            </td>
            <td width="40%" align="top">
                <xsl:value-of select="codes"/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="/reporterrors/summary">
        <h3 align="center">
            Summary
        </h3>
        <table width="100%">
            <tr>
                <td width="20%" align="top">
                    Total Errors:
                </td>
                <td width="20%" align="top">
                    <xsl:value-of select="totalerrors"/>
                </td>
                <td width="20%" align="top">
                    Line Item Errors:
                </td>
                <td width="20%" align="top">
                    <xsl:value-of select="totalitemerrors"/>
                </td>
            </tr>
            <tr>
                <td width="20%" align="top">
                    Billing Total
                </td>
                <td width="20%" align="top">
                    <xsl:value-of select="totalbilledfile"/>
                </td>
                <td width="20%" align="top">
                    Errors in Billing
                </td>
                <td width="20%" align="top">
                    <xsl:value-of select="totalbillederrors"/>
                </td>
            </tr>
        </table>
    </xsl:template>
    
 </xsl:stylesheet>
